$(function () {
    $(".tambah").click(function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var nama = $("#nm_barang").val();
        var qty = $("#qty").val();
        var satuan = $("#satuan").val();
        var harga = $("#harga").val();

        if (nama == "") {
            Toast.fire({
                icon: "error",
                title: "Ketikan nama barang!.",
            });
            $("#nm_barang").focus();
        } else if (qty == "") {
            Toast.fire({
                icon: "error",
                title: "Ketikan jumlah barang!.",
            });
            $("#qty").focus();
        } else if (satuan == "") {
            Toast.fire({
                icon: "error",
                title: "Pilih satuan barang!.",
            });
            $("#satuan").focus();
        } else if (harga == "") {
            Toast.fire({
                icon: "error",
                title: "Ketikan harga satuan barang!.",
            });
            $("#harga").focus();
        } else {
            $.ajax({
                type: "POST",
                url: "pengeluaran-tambah",
                data: {
                    nama: nama,
                    qty: qty,
                    satuan: satuan,
                    harga: harga,
                    _token: token,
                },
                success: function (data) {
                    if (data == "gagal") {
                        Swal.fire({
                            icon: "error",
                            title: "Opss...",
                            text: "Anda belum menginputakan data suppleir, Silahkan input data supplier terlebih dahulu!",
                        }).then((result) => {
                            if (result.isConfirmed) {
                                document.location.href = "/supplier";
                            }
                        });
                    } else if (data == "sukses") {
                        toastr.success("Barang berhasil di tambahkan .");
                        $("#nm_barang").val("");
                        $("#qty").val("");
                        $("#satuan").val("");
                        $("#harga").val("");
                        tampil_data();
                        data_total();
                    }
                },
            });
        }
    });

    tampil_data();
    function tampil_data() {
        $.ajax({
            type: "GET",
            url: "data-pengeluaran",
            success: function (data) {
                $("#viewpenge").html(data);
            },
        });
    }

    data_total();
    function data_total() {
        $.ajax({
            type: "GET",
            url: "data-total",
            success: function (data) {
                $("#ttl").html(data.total);
                $("#ttl2").html(data.total);
                $("#totalasl").val(data.totalasl);
            },
        });
    }

    $("#viewpenge").on("click", ".hapus", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $(this).attr("data-id");
        var nama = $(this).attr("data-nm");
        Swal.fire({
            title: "Apa anda yakin?",
            text: "Barang  ( " + nama + " ) akan di hapus!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Ya, Hapus!",
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: "post",
                    url: "delete-pengeluaran",
                    data: {
                        id: id,
                        _token: token,
                    },
                    success: function (data) {
                        toastr.success("Item berhasil dihapus.");
                        tampil_data();
                        data_total();

                        $("#nm_barang").val("");
                        $("#nm_barang").focus();
                    },
                });
            }
        });
    });

    $("#viewpenge").on("click", ".edit", function () {
        $(".txtedit").hide();
        $(this).next(".txtedit").show().focus();
        $(this).hide();
    });
    $("#viewpenge").on("focusout", ".txtedit", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = this.id;
        var value = $(this).val();
        var fl = $(this).attr("data-fl");

        $(this).hide();
        $(this).prev(".edit").show();
        $(this).prev(".edit").text(value);

        $.ajax({
            type: "POST",
            url: "edit-jml-pengeluran",
            data: {
                id: id,
                fl: fl,
                value: value,
                _token: token,
            },
            success: function (data) {
                toastr.success("Data berhasil dirubah.");
                tampil_data();
                data_total();

                $("#nm_barang").val("");
                $("#nm_barang").focus();
            },
        });
    });

    $(".simpan_pengeluaran").click(function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var ttl = $("#totalasl").val();
        var supplier = $("#supplier").val();
        var tgl = $("#tgl").val();

        if (ttl == 0) {
            Toast.fire({
                icon: "error",
                title: "Inputkan data barang!.",
            });
        } else if (supplier == "") {
            Toast.fire({
                icon: "error",
                title: "Pilih data supplier!.",
            });
        } else {
            $.ajax({
                type: "POST",
                url: "simpan-pengeluaran",
                data: {
                    ttl: ttl,
                    supplier: supplier,
                    tgl: tgl,
                    _token: token,
                },
                success: function (data) {
                    Swal.fire({
                        icon: "success",
                        title: "Berhasil",
                        text: "Data pengeluaran disimpan",
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.location.href = "";
                        }
                    });
                },
            });
        }
    });

    // ceklis
    $("#cekall").change(function () {
        if ($(this).prop("checked")) {
            $(".ceklis").prop("checked", true);
        } else {
            $(".ceklis").prop("checked", false);
        }
    });

    $("#pilih_hapus").click(function () {
        var allVals = [];
        $(".ceklis:checked").each(function () {
            allVals.push($(this).val());
        });
        var token = $("meta[name='csrf-token']").attr("content");

        if (allVals.length <= 0) {
            Toast.fire({
                icon: "error",
                title: "Ceklis data yang akan dihapus!!!.",
            });
        } else {
            Swal.fire({
                title: "Pastikan dengan benar!",
                text: "Data yang anda pilih akan dihapus!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Ya, Hapus!",
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: "deleteall-pengeluaran",
                        data: {
                            allVals: allVals,
                            _token: token,
                        },
                        beforeSend: function () {
                            $("#pilih_hapus").html(
                                '<i class="fas fa-spinner fa-spin"></i> Tunggu..'
                            );
                            $("#pilih_hapus").attr("disabled", true);
                        },
                        success: function (data) {
                            // alert(data)
                            $("#pilih_hapus").html(
                                '<i class="fa fa-trash"></i>'
                            );
                            $("#pilih_hapus").attr("disabled", true);
                            Swal.fire({
                                icon: "success",
                                title: "Berhasil",
                                text: "Data berhasil dihapus!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    document.location.href = "";
                                }
                            });
                        },
                    });
                }
            });
        }
    });

    $("#view").on("click", ".detail", function () {
        var token = $("meta[name='csrf-token']").attr("content");
        var id = $(this).attr("data-id");

        $.ajax({
            type: "POST",
            url: "detail-pengeluaran",
            data: {
                id: id,
                _token: token,
            },
            success: function (data) {
                $("#detail").modal("show");
                $("#datadetail").html(data);
            },
        });
    });
});
